# Copyright 2022 Mason James
#
# This file is part of Koha.
#
# Koha is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Koha is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Koha; if not, see <https://www.gnu.org/licenses>.

use Modern::Perl;
use Test::NoWarnings;
use Test::More tests => 2;
use File::Find;

SKIP: {
    skip "Building custom packages", 1, if $ENV{'CUSTOM_PACKAGE'};

    my $dir = ('installer/data/mysql/atomicupdate');
    my @files;

    find( \&wanted, $dir );

    sub wanted {
        return if $_ eq 'skeleton.pl';
        return if $_ eq 'README';
        return if $_ eq '.';
        push @files, $_;
        return;
    }

    is( scalar(@files), 0, "No atomic updates" ) or diag join "\n", @files;
}
