[% USE raw %]
[% IF whole.error %]
    [% IF whole.status == 'missing_identifier' %]
        <p><em>Please note:</em> Mandatory field Identifier is missing.</p>
    [% ELSIF whole.status == 'missing_branch' %]
        <p><em>Please note:</em> Library is a mandatory field.</p>
    [% ELSIF whole.status == 'invalid_borrower' %]
        <p><em>Please note:</em> The patrons details you entered are invalid.</p>
    [% ELSIF whole.status == 'invalid_branch' %]
        <p><em>Please note:</em> The library you chose is invalid.</p>
    [% ELSE %]
        <p>Unhandled error</p>
    [% END %]
[% END %]

[% IF whole.stage == "form" %]
    <h2>Migrating an ILL request</h2>
    <form id="standard_migrate_form" method="POST" action="">
        [% INCLUDE 'csrf-token.inc' %]
        <fieldset class="rows">
            <legend>General details</legend>
            <ol id="general-standard-fields">
                <li>
                    <label class="required" for="type">Type:</label>
                    <select class="form-select" name="type" id="type">
                        <option value=""></option>
                        [% IF whole.value.other.type.lower == "book" %]
                            <option value="book" selected="selected">Book</option>
                        [% ELSE %]
                            <option value="book">Book</option>
                        [% END %]
                        [% IF whole.value.other.type.lower == "chapter" %]
                            <option value="chapter" selected="selected">Chapter</option>
                        [% ELSE %]
                            <option value="chapter">Chapter</option>
                        [% END %]
                        [% IF whole.value.other.type.lower == "journal" %]
                            <option value="journal" selected="selected">Journal</option>
                        [% ELSE %]
                            <option value="journal">Journal</option>
                        [% END %]
                        [% IF whole.value.other.type.lower == "article" %]
                            <option value="article" selected="selected">Journal article</option>
                        [% ELSE %]
                            <option value="article">Journal article</option>
                        [% END %]
                        [% IF whole.value.other.type.lower == "thesis" %]
                            <option value="thesis" selected="selected">Thesis</option>
                        [% ELSE %]
                            <option value="thesis">Thesis</option>
                        [% END %]
                        [% IF whole.value.other.type.lower == "conference" %]
                            <option value="conference" selected="selected">Conference</option>
                        [% ELSE %]
                            <option value="conference">Conference</option>
                        [% END %]
                        [% IF whole.value.other.type.lower == "dvd" %]
                            <option value="dvd" selected="selected">DVD</option>
                        [% ELSE %]
                            <option value="dvd">DVD</option>
                        [% END %]
                        [% IF whole.value.other.type.lower == "other" %]
                            <option value="other" selected="selected">Other</option>
                        [% ELSE %]
                            <option value="other">Other</option>
                        [% END %]
                        [% IF whole.value.other.type.lower == "resource" %]
                            <option value="resource" selected="selected">Generic resource</option>
                        [% ELSE %]
                            <option value="resource">Generic resource</option>
                        [% END %]
                    </select>
                    [% IF required %]
                        <div class="required_label required">Required</div>
                    [% END %]
                </li>
            </ol>
        </fieldset>
        [% type = whole.value.other.type %]
        [% IF type %]
            [% INCLUDE "ill/backends/Standard/shared/forms/${type}.inc" %]
        [% END %]
        [% INCLUDE "ill/backends/Standard/shared/custom_fields.inc" %]
        <fieldset class="rows">
            <legend>Patron options</legend>
            <ol>
                <li>
                    <label class="required" for="cardnumber"> Card number or surname: </label>
                    <input type="text" name="cardnumber" id="cardnumber" type="text" value="" />
                    <div class="required_label required">Required</div>
                </li>
                <li>
                    <label class="required" for="branchcode">Destination library:</label>
                    <select id="branchcode" name="branchcode">
                        <option value=""></option>
                        [% FOREACH branch IN branches %]
                            <option value="[% branch.branchcode | html %]"> [% branch.branchname | html %] </option>
                        [% END %]
                    </select>
                    <div class="required_label required">Required</div>
                </li>
            </ol>
        </fieldset>
        <fieldset class="action">
            <input id="ill-submit" type="submit" value="Migrate" />
            <a class="cancel" href="/cgi-bin/koha/ill/ill-requests.pl">Cancel</a>
        </fieldset>
        <input type="hidden" name="op" value="cud-migrate" />
    </form>
    [% BLOCK backend_jsinclude %]
        <script>
            var core = [ [% whole.core | $raw %] ];
            // <![CDATA[]
            [% INCLUDE "ill/backends/Standard/shared/shared.js" %]
            // ]]>
        </script>
    [% END %]
[% ELSE %]
    <p>Unknown stage. This should not have happened. </p>
[% END %]
