package Koha::Library::Groups;

# Copyright ByWater Solutions 2016
#
# This file is part of Koha.
#
# Koha is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Koha is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Koha; if not, see <http://www.gnu.org/licenses>.

use Modern::Perl;


use Koha::Database;

use Koha::Library::Group;

use base qw(Koha::Objects);

=head1 NAME

Koha::Library::Groups - Koha Library::Group object set class

=head1 API

=head2 Class Methods

=head3 get_root_groups

my @root_groups = $self->get_root_group()

=cut

sub get_root_groups {
    my ( $self ) = @_;

    return $self->search( { parent_id => undef }, { order_by => 'title' } );
}

=head3 get_search_groups

my $search_groups = $self->get_search_groups({[interface => 'staff' || 'opac']}))

Returns search groups for the specified interface.
Defaults to OPAC if no interface is specified.

=cut

sub get_search_groups {
    my ( $self, $params ) = @_;
    my $interface = $params->{interface} || q{};

    my $field = $interface eq 'staff' ? 'ft_search_groups_staff' : 'ft_search_groups_opac';

    return $self->search( { $field => 1 }, { order_by => 'title' } );
}


=head3 get_root_ancestor

my $root_ancestor = $self->get_root_ancestor( {id => $group_id } )

Retrieve root ancestor group for a specified id.

=cut

sub get_root_ancestor {
    my ( $self, $params ) = @_;
    my $row = $self->find($params);
    return $row unless $row->parent_id;
    return $self->get_root_ancestor( { id => $row->parent_id } );
}


=head3 type

=cut

sub _type {
    return 'LibraryGroup';
}

=head3 object_class

=cut

sub object_class {
    return 'Koha::Library::Group';
}

=head1 AUTHOR

Kyle M Hall <kyle@bywatersolutions.com>

=cut

1;
