#!/usr/bin/perl

# This file is part of Koha.
#
# Koha is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Koha is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Koha; if not, see <http://www.gnu.org/licenses>.

use Modern::Perl;

use Test::More tests => 3;

use_ok('Koha::Auth::Permissions');

subtest 'normal staff user test' => sub {

    plan tests => 1;

    my $flags = {
        'acquisition'      => 0,
        'borrowers'        => 0,
        'cash_management'  => 0,
        'catalogue'        => 0,
        'circulate'        => { circulate_remaining_permissions => 1, },
        'clubs'            => 0,
        'coursereserves'   => 0,
        'editauthorities'  => 0,
        'editcatalogue'    => 0,
        'ill'              => 0,
        'lists'            => 0,
        'parameters'       => 0,
        'permissions'      => 0,
        'plugins'          => 0,
        'problem_reports'  => 0,
        'recalls'          => 0,
        'reports'          => 1,
        'reserveforothers' => 0,
        'self_check'       => 0,
        'serials'          => 0,
        'staffaccess'      => 1,
        'stockrotation'    => 0,
        'suggestions'      => 0,
        'superlibrarian'   => 0,
        'tools'            => 0,
        'updatecharges'    => 0,
    };
    my $authz    = Koha::Auth::Permissions->get_authz_from_flags( { flags => $flags } );
    my $expected = {
        'CAN_user_staffaccess'                               => 1,
        'CAN_user_circulate'                                 => 1,
        'CAN_user_circulate_circulate_remaining_permissions' => 1,
        'CAN_user_reports'                                   => 1,
        'CAN_user_reports_create_reports'                    => 1,
        'CAN_user_reports_delete_reports'                    => 1,
        'CAN_user_reports_execute_reports'                   => 1,
    };
    is_deeply( $authz, $expected, 'Expected permissions generated for normal staff user' );
};

subtest 'superlibrarian tests' => sub {

    plan tests => 1;

    my $flags = {
        'acquisition'      => 0,
        'borrowers'        => 0,
        'cash_management'  => 0,
        'catalogue'        => 0,
        'circulate'        => 0,
        'clubs'            => 0,
        'coursereserves'   => 0,
        'editauthorities'  => 0,
        'editcatalogue'    => 0,
        'ill'              => 0,
        'lists'            => 0,
        'parameters'       => 0,
        'permissions'      => 0,
        'plugins'          => 0,
        'problem_reports'  => 0,
        'recalls'          => 0,
        'reports'          => 0,
        'reserveforothers' => 0,
        'self_check'       => 0,
        'serials'          => 0,
        'staffaccess'      => 0,
        'stockrotation'    => 0,
        'suggestions'      => 0,
        'superlibrarian'   => 1,
        'tools'            => 0,
        'updatecharges'    => 0,
    };

    my $authz = Koha::Auth::Permissions->get_authz_from_flags({ flags => $flags });

    my $expected = {
        'CAN_user_acquisition_budget_add_del'                       => 1,
        'CAN_user_acquisition_budget_manage_all'                    => 1,
        'CAN_user_acquisition_budget_manage'                        => 1,
        'CAN_user_acquisition_budget_modify'                        => 1,
        'CAN_user_acquisition_contracts_manage'                     => 1,
        'CAN_user_acquisition_currencies_manage'                    => 1,
        'CAN_user_acquisition_delete_baskets'                       => 1,
        'CAN_user_acquisition_delete_invoices'                      => 1,
        'CAN_user_acquisition_edi_manage'                           => 1,
        'CAN_user_acquisition_edit_invoices'                        => 1,
        'CAN_user_acquisition_group_manage'                         => 1,
        'CAN_user_acquisition_issue_manage'                         => 1,
        'CAN_user_acquisition_merge_invoices'                       => 1,
        'CAN_user_acquisition_order_manage_all'                     => 1,
        'CAN_user_acquisition_order_manage'                         => 1,
        'CAN_user_acquisition_order_receive'                        => 1,
        'CAN_user_acquisition_period_manage'                        => 1,
        'CAN_user_acquisition_planning_manage'                      => 1,
        'CAN_user_acquisition_reopen_closed_invoices'               => 1,
        'CAN_user_acquisition_vendors_manage'                       => 1,
        'CAN_user_acquisition'                                      => 1,
        'CAN_user_borrowers_send_messages_to_borrowers'             => 1,
        'CAN_user_borrowers_delete_borrowers'                       => 1,
        'CAN_user_borrowers_edit_borrowers'                         => 1,
        'CAN_user_borrowers_list_borrowers'                         => 1,
        'CAN_user_borrowers_view_borrower_infos_from_any_libraries' => 1,
        'CAN_user_borrowers'                                        => 1,
        'CAN_user_cash_management_anonymous_refund'                 => 1,
        'CAN_user_cash_management_cashup'                           => 1,
        'CAN_user_cash_management_takepayment'                      => 1,
        'CAN_user_cash_management'                                  => 1,
        'CAN_user_catalogue'                                        => 1,
        'CAN_user_circulate_circulate_remaining_permissions'        => 1,
        'CAN_user_circulate_force_checkout'                         => 1,
        'CAN_user_circulate_manage_bookings'                        => 1,
        'CAN_user_circulate_manage_checkout_notes'                  => 1,
        'CAN_user_circulate_manage_curbside_pickups'                => 1,
        'CAN_user_circulate_manage_restrictions'                    => 1,
        'CAN_user_circulate_overdues_report'                        => 1,
        'CAN_user_circulate_override_renewals'                      => 1,
        'CAN_user_circulate'                                        => 1,
        'CAN_user_clubs_edit_clubs'                                 => 1,
        'CAN_user_clubs_edit_templates'                             => 1,
        'CAN_user_clubs_enroll'                                     => 1,
        'CAN_user_clubs'                                            => 1,
        'CAN_user_coursereserves_add_reserves'                      => 1,
        'CAN_user_coursereserves_delete_reserves'                   => 1,
        'CAN_user_coursereserves_manage_courses'                    => 1,
        'CAN_user_coursereserves'                                   => 1,
        'CAN_user_editauthorities'                                  => 1,
        'CAN_user_editcatalogue_advanced_editor'                    => 1,
        'CAN_user_editcatalogue_create_shared_macros'               => 1,
        'CAN_user_editcatalogue_delete_all_items'                   => 1,
        'CAN_user_editcatalogue_delete_shared_macros'               => 1,
        'CAN_user_editcatalogue_edit_any_item'                      => 1,
        'CAN_user_editcatalogue_edit_catalogue'                     => 1,
        'CAN_user_editcatalogue_edit_items_restricted'              => 1,
        'CAN_user_editcatalogue_edit_items'                         => 1,
        'CAN_user_editcatalogue_edit_locked_records'                => 1,
        'CAN_user_editcatalogue_fast_cataloging'                    => 1,
        'CAN_user_editcatalogue_manage_item_groups'                 => 1,
        'CAN_user_editcatalogue_manage_item_editor_templates'       => 1,
        'CAN_user_editcatalogue_set_record_sources'                 => 1,
        'CAN_user_editcatalogue'                                    => 1,
        'CAN_user_ill'                                              => 1,
        'CAN_user_lists_delete_public_lists'                        => 1,
        'CAN_user_lists_edit_public_lists'                          => 1,
        'CAN_user_lists_edit_public_list_contents'                  => 1,
        'CAN_user_lists'                                            => 1,
        'CAN_user_parameters_manage_accounts'                       => 1,
        'CAN_user_parameters_manage_additional_fields'              => 1,
        'CAN_user_parameters_manage_audio_alerts'                   => 1,
        'CAN_user_parameters_manage_auth_values'                    => 1,
        'CAN_user_parameters_manage_background_jobs'                => 1,
        'CAN_user_parameters_manage_cash_registers'                 => 1,
        'CAN_user_parameters_manage_circ_rules_from_any_libraries'  => 1,
        'CAN_user_parameters_manage_circ_rules'                     => 1,
        'CAN_user_parameters_manage_cities'                         => 1,
        'CAN_user_parameters_manage_classifications'                => 1,
        'CAN_user_parameters_manage_column_config'                  => 1,
        'CAN_user_parameters_manage_curbside_pickups'               => 1,
        'CAN_user_parameters_manage_didyoumean'                     => 1,
        'CAN_user_parameters_manage_identity_providers'             => 1,
        'CAN_user_parameters_manage_item_circ_alerts'               => 1,
        'CAN_user_parameters_manage_item_search_fields'             => 1,
        'CAN_user_parameters_manage_itemtypes'                      => 1,
        'CAN_user_parameters_manage_keyboard_shortcuts'             => 1,
        'CAN_user_parameters_manage_libraries'                      => 1,
        'CAN_user_parameters_manage_mana'                           => 1,
        'CAN_user_parameters_manage_marc_frameworks'                => 1,
        'CAN_user_parameters_manage_marc_overlay_rules'             => 1,
        'CAN_user_parameters_manage_matching_rules'                 => 1,
        'CAN_user_parameters_manage_oai_sets'                       => 1,
        'CAN_user_parameters_manage_patron_attributes'              => 1,
        'CAN_user_parameters_manage_patron_categories'              => 1,
        'CAN_user_parameters_manage_patron_restrictions'            => 1,
        'CAN_user_parameters_manage_record_sources'                 => 1,
        'CAN_user_parameters_manage_search_engine_config'           => 1,
        'CAN_user_parameters_manage_search_filters'                 => 1,
        'CAN_user_parameters_manage_search_targets'                 => 1,
        'CAN_user_parameters_manage_sms_providers'                  => 1,
        'CAN_user_parameters_manage_smtp_servers'                   => 1,
        'CAN_user_parameters_manage_sysprefs'                       => 1,
        'CAN_user_parameters_manage_transfers'                      => 1,
        'CAN_user_parameters_manage_usage_stats'                    => 1,
        'CAN_user_parameters_parameters_remaining_permissions'      => 1,
        'CAN_user_parameters'                                       => 1,
        'CAN_user_permissions'                                      => 1,
        'CAN_user_plugins_admin'                                    => 1,
        'CAN_user_plugins_configure'                                => 1,
        'CAN_user_plugins_manage'                                   => 1,
        'CAN_user_plugins_report'                                   => 1,
        'CAN_user_plugins_tool'                                     => 1,
        'CAN_user_plugins'                                          => 1,
        'CAN_user_problem_reports_manage_problem_reports'           => 1,
        'CAN_user_problem_reports'                                  => 1,
        'CAN_user_recalls_manage_recalls'                           => 1,
        'CAN_user_recalls'                                          => 1,
        'CAN_user_reports_create_reports'                           => 1,
        'CAN_user_reports_delete_reports'                           => 1,
        'CAN_user_reports_execute_reports'                          => 1,
        'CAN_user_reports'                                          => 1,
        'CAN_user_reserveforothers_modify_holds_priority'           => 1,
        'CAN_user_reserveforothers_place_holds'                     => 1,
        'CAN_user_reserveforothers'                                 => 1,
        'CAN_user_self_check_self_checkin_module'                   => 1,
        'CAN_user_self_check_self_checkout_module'                  => 1,
        'CAN_user_self_check'                                       => 1,
        'CAN_user_serials_check_expiration'                         => 1,
        'CAN_user_serials_claim_serials'                            => 1,
        'CAN_user_serials_create_subscription'                      => 1,
        'CAN_user_serials_delete_subscription'                      => 1,
        'CAN_user_serials_edit_subscription'                        => 1,
        'CAN_user_serials_receive_serials'                          => 1,
        'CAN_user_serials_renew_subscription'                       => 1,
        'CAN_user_serials_routing'                                  => 1,
        'CAN_user_serials_superserials'                             => 1,
        'CAN_user_serials'                                          => 1,
        'CAN_user_staffaccess'                                      => 1,
        'CAN_user_stockrotation_manage_rota_items'                  => 1,
        'CAN_user_stockrotation_manage_rotas'                       => 1,
        'CAN_user_stockrotation'                                    => 1,
        'CAN_user_suggestions_suggestions_manage'                   => 1,
        'CAN_user_suggestions'                                      => 1,
        'CAN_user_superlibrarian'                                   => 1,
        'CAN_user_tools_access_files'                               => 1,
        'CAN_user_tools_batch_extend_due_dates'                     => 1,
        'CAN_user_tools_batch_upload_patron_images'                 => 1,
        'CAN_user_tools_delete_anonymize_patrons'                   => 1,
        'CAN_user_tools_edit_additional_contents'                   => 1,
        'CAN_user_tools_edit_calendar'                              => 1,
        'CAN_user_tools_edit_notice_status_triggers'                => 1,
        'CAN_user_tools_edit_notices'                               => 1,
        'CAN_user_tools_edit_patrons'                               => 1,
        'CAN_user_tools_edit_quotes'                                => 1,
        'CAN_user_tools_export_catalog'                             => 1,
        'CAN_user_tools_import_patrons'                             => 1,
        'CAN_user_tools_inventory'                                  => 1,
        'CAN_user_tools_items_batchdel'                             => 1,
        'CAN_user_tools_items_batchmod_restricted'                  => 1,
        'CAN_user_tools_items_batchmod'                             => 1,
        'CAN_user_tools_label_creator'                              => 1,
        'CAN_user_tools_manage_csv_profiles'                        => 1,
        'CAN_user_tools_manage_patron_lists'                        => 1,
        'CAN_user_tools_manage_staged_marc'                         => 1,
        'CAN_user_tools_marc_modification_templates'                => 1,
        'CAN_user_tools_moderate_comments'                          => 1,
        'CAN_user_tools_moderate_tags'                              => 1,
        'CAN_user_tools_records_batchdel'                           => 1,
        'CAN_user_tools_records_batchmod'                           => 1,
        'CAN_user_tools_rotating_collections'                       => 1,
        'CAN_user_tools_schedule_tasks'                             => 1,
        'CAN_user_tools_stage_marc_import'                          => 1,
        'CAN_user_tools_upload_general_files'                       => 1,
        'CAN_user_tools_upload_local_cover_images'                  => 1,
        'CAN_user_tools_upload_manage'                              => 1,
        'CAN_user_tools_view_system_logs'                           => 1,
        'CAN_user_tools'                                            => 1,
        'CAN_user_updatecharges_discount'                           => 1,
        'CAN_user_updatecharges_manual_credit'                      => 1,
        'CAN_user_updatecharges_manual_invoice'                     => 1,
        'CAN_user_updatecharges_payout'                             => 1,
        'CAN_user_updatecharges_refund'                             => 1,
        'CAN_user_updatecharges_remaining_permissions'              => 1,
        'CAN_user_updatecharges_writeoff'                           => 1,
        'CAN_user_updatecharges'                                    => 1,
    };

    is_deeply($authz,$expected,'Expected permissions generated for superlibrarian');
};
