# RELEASE NOTES FOR KOHA 22.11.05
02 May 2023

Koha is the first free and open source software library automation
package (ILS). Development is sponsored by libraries of varying types
and sizes, volunteers, and support companies from around the world. The
website for the Koha project is:

- [Koha Community](http://koha-community.org)

Koha 22.11.05 can be downloaded from:

- [Download](http://download.koha-community.org/koha-22.11.05.tar.gz)

Installation instructions can be found at:

- [Koha Wiki](http://wiki.koha-community.org/wiki/Installation_Documentation)
- OR in the INSTALL files that come in the tarball

Koha 22.11.05 is a bugfix/maintenance release.

It includes 2 enhancements, 152 bugfixes.

### System requirements

You can learn about the system components (like OS and database) needed for running Koha [here](https://wiki.koha-community.org/wiki/System_requirements_and_recommendations).




## Enhancements

### Architecture, internals, and plumbing

- [[33289]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33289) Vue - Add API client class to interact with svc/config/systempreferences

  **Sponsored by** *Bibliothèque Universitaire des Langues et Civilisations (BULAC)*

### I18N/L10N

- [[33077]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33077) Improve ease of translating template title tags


## Critical bugs fixed

### Acquisitions

- [[32437]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32437) When adding to a basket form a staged file and matching the imported records are ignored when set to overwrite

### Architecture, internals, and plumbing

- [[33309]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33309) Race condition while checkout renewal with ES
- [[33368]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33368) borrowers.flags is about to reach the limit

### Cataloging

- [[30966]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=30966) Record overlay rules - can't use Z39.50 filter

  **Sponsored by** *Koha-Suomi Oy*
- [[33375]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33375) Advanced editor crashes when using MySQL 8 due to reserved rank keyword

### Circulation

- [[29234]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=29234) Transfers generated by stock rotation alert but do not initiate at checkin
- [[33574]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33574) Restriction type is not stored, all restrictions fall back to MANUAL

### ERM

- [[33481]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33481) EBSCO ws return 415: Content type 'application/octet-stream' not supported
- [[33485]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33485) Add/remove title from holdings is not using the correct endpoint

### Label/patron card printing

- [[31259]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=31259) Downloading patron card PDF hangs the server

### MARC Authority data support

- [[33159]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33159) Thesaurus is not defined by second indicator for controlled fields outside of 6XX

### REST API

- [[32336]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32336) MARCXML output of REST API may be badly encoded (UNIMARC)

### Searching - Elasticsearch

- [[33019]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33019) Records not indexed in Elasticsearch ES when first catalogued


## Other bugs fixed

### Acquisitions

- [[31722]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=31722) Don't show EDIFACT note on basket group page if EDIFACT is turned off
- [[33238]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33238) Error adding suggestion to basket as non-superlibrarian (Bug 29886 follow-up)
- [[33414]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33414) Dates displayed in ISO format in orders by fund

### Architecture, internals, and plumbing

- [[32418]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32418) CRASH: Can't call method "unblessed" on an undefined value at cataloguing/additem.pl
- [[32716]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32716) update NGINX config examples to increase proxy_buffer_size

  >Set proxy_buffer_size in the example NGINX configuration to reduce chances that REST API responses that use pagination get dropped by NGINX
- [[32794]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32794) mailto links in 856 can be incorrectly formed by XSLT
- [[33088]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33088) background-job-progressbar.js no longer needed in batch_record_modification.tt
- [[33229]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33229) Patron reading history should be cleared when privacy set to never
- [[33341]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33341) Perl 5.36 doesn't consider some of our code cool
- [[33367]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33367) tmp/modified_authorities/README.txt seems useless

### Cataloging

- [[32830]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32830) Fix cataloguing/value_builder/unimarc_field_116.pl
- [[32831]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32831) Fix cataloguing/value_builder/unimarc_field_117.pl
- [[32832]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32832) Fix cataloguing/value_builder/unimarc_field_120.pl
- [[32833]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32833) Fix cataloguing/value_builder/unimarc_field_121a.pl
- [[32834]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32834) Fix cataloguing/value_builder/unimarc_field_121b.pl
- [[32836]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32836) Fix cataloguing/value_builder/unimarc_field_123a.pl
- [[32837]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32837) Fix cataloguing/value_builder/unimarc_field_123d.pl
- [[32838]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32838) Fix cataloguing/value_builder/unimarc_field_123e.pl
- [[32839]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32839) Fix cataloguing/value_builder/unimarc_field_123f.pl
- [[32840]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32840) Fix cataloguing/value_builder/unimarc_field_123g.pl
- [[32841]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32841) Fix cataloguing/value_builder/unimarc_field_123i.pl
- [[32842]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32842) Fix cataloguing/value_builder/unimarc_field_123j.pl
- [[32843]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32843) Fix cataloguing/value_builder/unimarc_field_124a.pl
- [[32844]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32844) Fix cataloguing/value_builder/unimarc_field_124b.pl
- [[32845]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32845) Fix cataloguing/value_builder/unimarc_field_124c.pl
- [[32846]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32846) Fix cataloguing/value_builder/unimarc_field_124d.pl
- [[32847]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32847) Fix cataloguing/value_builder/unimarc_field_124e.pl
- [[32848]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32848) Fix cataloguing/value_builder/unimarc_field_124f.pl
- [[32849]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32849) Fix cataloguing/value_builder/unimarc_field_124g.pl
- [[32850]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32850) Fix cataloguing/value_builder/unimarc_field_124.pl
- [[32851]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32851) Fix cataloguing/value_builder/unimarc_field_125a.pl
- [[32852]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32852) Fix cataloguing/value_builder/unimarc_field_125b.pl
- [[32854]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32854) Fix cataloguing/value_builder/unimarc_field_126a.pl
- [[32855]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32855) Fix cataloguing/value_builder/unimarc_field_126b.pl
- [[32857]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32857) Fix cataloguing/value_builder/unimarc_field_127.pl
- [[32858]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32858) Fix cataloguing/value_builder/unimarc_field_128a.pl
- [[32859]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32859) Fix cataloguing/value_builder/unimarc_field_128b.pl
- [[32860]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32860) Fix cataloguing/value_builder/unimarc_field_128c.pl
- [[32861]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32861) Fix cataloguing/value_builder/unimarc_field_130.pl
- [[32862]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32862) Fix cataloguing/value_builder/unimarc_field_135a.pl
- [[32863]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32863) Fix cataloguing/value_builder/unimarc_field_140.pl
- [[32864]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32864) Fix cataloguing/value_builder/unimarc_field_141.pl

### Circulation

- [[32883]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32883) Curbside pickups - Order "To be staged" by date and time of scheduled pickup

### Command-line Utilities

- [[32800]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32800) build_oai_sets.pl fails on deleted records
- [[33285]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33285) It should be possible to specify the separator used in runreport.pl

### ERM

- [[32807]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32807) No need to fetch all if we need to know if one exist
- [[33290]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33290) Incorrect variable used in http-client.js

  **Sponsored by** *Bibliothèque Universitaire des Langues et Civilisations (BULAC)*
- [[33346]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33346) Add Help link to Koha manual in ERM module
- [[33381]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33381) Active link in the menu is not always correctly styled
- [[33422]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33422) ERM - Search header should change to match the section you are in

### Hold requests

- [[33198]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33198) request.pl is calculating pickup locations that are not used

### Holidays

- [[31057]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=31057) Add clarifying text to 'To date' in the calendar tool

### I18N/L10N

- [[31640]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=31640) Fuzzy translations of preferences can cause missing sections and inaccurate translations
- [[33323]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33323) Select button in patron search modal is not translatable
- [[33332]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33332) Fix formatting of TT comments to improve translations

### ILL

- [[28641]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=28641) ILLHiddenRequestStatuses does not consider custom statuses

  **Sponsored by** *PTFS Europe*

### MARC Authority data support

- [[32279]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32279) GetAuthorizedHeading missing from exports of C4::AuthoritiesMarc
- [[32280]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32280) Export method ImportBreedingAuth from C4::Breeding

### OPAC

- [[25590]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=25590) Street number is missing from alternate address in the OPAC
- [[29311]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=29311) Do not allow editing of bibliographic information when entering suggestion from existing bibs
- [[30162]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=30162) XSLT has broken link for traced series because of OPAC/staff interface confusion
- [[33160]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33160) Make sure 773 (host item entry) displays in the cart when not linked by $w
- [[33299]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33299) Item type column is empty when placing item level holds in OPAC

### Packaging

- [[33168]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33168) Timeline on "About Koha" is not working for package installs

### Patrons

- [[32510]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32510) "New list" option is not available when too many patron's lists
- [[32976]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32976) Patron image Add/Edit button should not appear if permission is turned off

### Reports

- [[27513]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=27513) Add description to reports page

### Searching

- [[13976]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=13976) Sorting search results by popularity is alphabetical

  >This patch fixes the sorting of searches by popularity, ensuring that results are sorted numerically.
  >
  >Note: The popularity search requires the use of either the syspref UpdateTotalIssuesOnCirc or the update_totalissue.pl cronjob

### Searching - Elasticsearch

- [[31695]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=31695) Type standard number is missing field ci_raw in field_config.yaml
- [[33486]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33486) Remove Koha::BackgroundJob::UpdateElasticIndex->process routine

### Searching - Zebra

- [[31841]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=31841) Shelving location search in staff interface sometimes creates invalid Zebra query

### Serials

- [[33040]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33040) Add "Date published (text)" to serials tab on record view (detail.pl)
- [[33261]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33261) Dates for issues on subscription detail page display unformatted

### Staff interface

- [[32301]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32301) Show correct defaultSortField in staff interface advanced search
- [[33133]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33133) Fast cataloging should be visible in cataloging
- [[33391]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33391) Currently active menu item on navmenulist should not change style on hover

### System Administration

- [[32964]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32964) OPACResultsMaxItemsUnavailable description is misleading
- [[33509]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33509) Staff search result list shows "other holdings" with AlternateHoldingsField when there are no alternate holdings

### Templates

- [[31409]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=31409) Set focus for cursor to Fund code when adding a new fund
- [[31994]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=31994) Clicking the next button of a DataTable loading its data from the HTML does nothing
- [[32003]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32003) Accessibility: Order search results has two h1 headings
- [[32127]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32127) Sort patron categories by description in templates
- [[32217]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32217) Typo: Error authenticating in external provider
- [[32263]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32263) Capitalization: ...and on the Libraries page in the OPAC.
- [[32447]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32447) In items table barcode column can not be filtered
- [[32634]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32634) Add 'page-section' to various pages
- [[32771]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32771) Standardize structure around action fieldsets in serials
- [[32945]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32945) Capitalization: id (part 2)
- [[32954]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32954) Standardize action fieldsets in rotating collections, suggestions, tools
- [[32955]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32955) Standardize structure around action fieldsets in various templates
- [[32956]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32956) Use template wrapper for HTML customizations tabs
- [[32969]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32969) Remove references to jQueryUI assets and style in the OPAC
- [[33001]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33001) Use template wrapper for breadcrumbs: Acquisitions part 2
- [[33005]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33005) Use template wrapper for breadcrumbs: Acquisitions part 3
- [[33006]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33006) Use template wrapper for breadcrumbs: Administration part 1
- [[33007]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33007) Use template wrapper for breadcrumbs: Administration part 2
- [[33111]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33111) Use template wrapper for breadcrumbs: Administration part 4
- [[33129]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33129) Use template wrapper for breadcrumbs: Administration part 6
- [[33130]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33130) Use template wrapper for breadcrumbs: Authorities
- [[33131]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33131) Use template wrapper for breadcrumbs: Catalog part 1
- [[33136]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33136) Catalog search pop-up is missing page-section
- [[33137]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33137) Make sure columns on transactions and 'pay fines' tab are matching up
- [[33147]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33147) Use template wrapper for breadcrumbs: Catalog part 2
- [[33148]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33148) Use template wrapper for breadcrumbs: Cataloging
- [[33149]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33149) Use template wrapper for breadcrumbs: Circulation part 1
- [[33154]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33154) Tab WRAPPER follow-up: label text must be translatable
- [[33180]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33180) Use template wrapper for tabs: Budgets and Search engine configuration
- [[33181]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33181) Use template wrapper for tabs on record merge pages
- [[33185]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33185) Use template wrapper for tabs on authority and biblio MARC details
- [[33186]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33186) Use template wrapper for tabs on search history and advanced search
- [[33187]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33187) Use template wrapper for tabs article requests and holds awaiting pickup pages
- [[33265]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33265) Additional unformatted navigation items when on serial receive page
- [[33272]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33272) Color of the "(remove)" link when an item is in the cart (OPAC)
- [[33278]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33278) Correct JS for activating default tab on various pages
- [[33293]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33293) Use template wrapper for tabs: Holds
- [[33294]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33294) Use template wrapper for tabs: Checkout history
- [[33307]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33307) Use template wrapper for tabs: Lists
- [[33322]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33322) "Please select at least one suggestion" when doing a catalog search from suggestions page
- [[33324]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33324) Use template wrapper for tabs: Tools
- [[33333]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33333) Use template wrapper for tabs: SQL reports
- [[33345]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33345) On-site checkout checkbox does not work since issue date using flatpickr
- [[33372]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33372) Use template wrapper for breadcrumbs: Circulation part 2
- [[33373]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33373) Use template wrapper for breadcrumbs: Circulation part 3
- [[33382]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33382) Use template wrapper for breadcrumbs: Patron clubs
- [[33383]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33383) Use template wrapper for breadcrumbs: Course reserves
- [[33384]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33384) Use template wrapper for breadcrumbs: Labels
- [[33385]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33385) Use template wrapper for breadcrumbs: Patrons part 1
- [[33386]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33386) Use template wrapper for breadcrumbs: Patrons part 2
- [[33387]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33387) Use template wrapper for breadcrumbs: Patrons part 3
- [[33389]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33389) Use template wrapper for breadcrumbs: Patrons part 5
- [[33409]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33409) Use template wrapper for breadcrumbs: Patrons lists
- [[33410]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33410) Use template wrapper for breadcrumbs: Patron card creator
- [[33429]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33429) Use template wrapper for breadcrumbs: Plugins
- [[33434]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33434) Use template wrapper for breadcrumbs: Point of sale
- [[33436]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33436) Use template wrapper for breadcrumbs: Reports part 1

### Test Suite

- [[32648]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32648) Search.t is failing randomly
- [[32710]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=32710) UI/Form/Builder/Item.t is failing randomly

### Z39.50 / SRU / OpenSearch Servers

- [[26433]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=26433) Control number search option missing from SRU mapping options
- [[33231]](http://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=33231) (Bug 30813 follow-up) No publication date nor edition statements in Z39.50 biblio search results



## Documentation

The Koha manual is maintained in Sphinx. The home page for Koha
documentation is

- [Koha Documentation](http://koha-community.org/documentation/)



The Git repository for the Koha manual can be found at

- [Koha Git Repository](https://gitlab.com/koha-community/koha-manual)


## Translations

Complete or near-complete translations of the OPAC and staff
interface are available in this release for the following languages:

- Arabic (72.5%)
- Armenian (100%)
- Bulgarian (91.4%)
- Chinese (Taiwan) (82.2%)
- Czech (59.2%)
- English (New Zealand) (68.8%)
- English (USA)
- Finnish (95.4%)
- French (99.4%)
- French (Canada) (95.6%)
- German (100%)
- German (Switzerland) (50.5%)
- Greek (50.2%)
- Hindi (99.1%)
- Italian (92.7%)
- Nederlands-Nederland (Dutch-The Netherlands) (83.1%)
- Norwegian Bokmål (64.7%)
- Persian (69.7%)
- Polish (93.1%)
- Portuguese (89.6%)
- Portuguese (Brazil) (99.3%)
- Russian (94.3%)
- Slovak (62.2%)
- Spanish (98.1%)
- Swedish (75.4%)
- Telugu (77.9%)
- Turkish (88%)
- Ukrainian (78.7%)

Partial translations are available for various other languages.

The Koha team welcomes additional translations; please see

- [Koha Translation Info](http://wiki.koha-community.org/wiki/Translating_Koha)

For information about translating Koha, and join the koha-translate 
list to volunteer:

- [Koha Translate List](http://lists.koha-community.org/cgi-bin/mailman/listinfo/koha-translate)

The most up-to-date translations can be found at:

- [Koha Translation](http://translate.koha-community.org/)

## Release Team

The release team for Koha 22.11.05 is


- Release Manager: Tomás Cohen Arazi

- Release Manager assistants:
  - Jonathan Druart
  - Martin Renvoize

- QA Manager: Katrin Fischer

- QA Team:
  - Aleisha Amohia
  - Nick Clemens
  - David Cook
  - Jonathan Druart
  - Lucas Gass
  - Victor Grousset
  - Kyle M Hall
  - Martin Renvoize
  - Marcel de Rooy
  - Fridolin Somers

- Topic Experts:
  - UI Design -- Owen Leonard
  - Zebra -- Fridolin Somers
  - REST API -- Martin Renvoize

- Bug Wranglers:
  - Aleisha Amohia
  - Indranil Das Gupta

- Packaging Manager: Mason James


- Documentation Manager: Caroline Cyr La Rose


- Documentation Team:
  - Aude Charillon
  - David Nind
  - Lucy Vaux-Harvey

- Translation Manager: Bernardo González Kriegel


- Wiki curators: 
  - Thomas Dukleth
  - Katrin Fischer

- Release Maintainers:
  - 22.11 -- PTFS Europe (Martin Renvoize, Matt Blenkinsop, Jacob O'Mara, Pedro Amorim)
  - 22.05 -- Lucas Gass
  - 21.11 -- Arthur Suzuki
  - 21.05 -- Wainui Witika-Park

## Credits
We thank the following libraries, companies, and other institutions who are known to have sponsored
new features in Koha 22.11.05

- [Bibliothèque Universitaire des Langues et Civilisations (BULAC)](http://www.bulac.fr)
- [Koha-Suomi Oy](https://koha-suomi.fi)
- [PTFS Europe](https://ptfs-europe.com)

We thank the following individuals who contributed patches to Koha 22.11.05

- Pedro Amorim (4)
- Tomás Cohen Arazi (9)
- Matt Blenkinsop (2)
- Jérémy Breuillard (1)
- Kevin Carnes (1)
- Galen Charlton (1)
- Nick Clemens (32)
- David Cook (3)
- Paul Derscheid (2)
- Jonathan Druart (14)
- Katrin Fischer (15)
- Lucas Gass (5)
- Kyle M Hall (1)
- Mark Hofstetter (1)
- Olivier Hubert (1)
- Mason James (1)
- Janusz Kaczmarek (2)
- Owen Leonard (53)
- Julian Maurice (34)
- Philip Orr (4)
- Johanna Raisa (1)
- Martin Renvoize (5)
- Marcel de Rooy (5)
- Caroline Cyr La Rose (1)
- Andreas Roussos (1)
- Fridolin Somers (9)
- Koha translators (1)
- Clemens Tubach (1)
- Hammat Wele (1)

We thank the following libraries, companies, and other institutions who contributed
patches to Koha 22.11.05

- Athens County Public Libraries (53)
- BibLibre (44)
- Bibliotheksservice-Zentrum Baden-Württemberg (BSZ) (15)
- ByWater-Solutions (38)
- Dataly Tech (1)
- Equinox Open Library Initiative (1)
- hofstetter.at (1)
- Independant Individuals (3)
- kit.edu (1)
- Koha Community Developers (14)
- KohaAloha (1)
- lmscloud.de (6)
- pfs-europe.com (1)
- Prosentient Systems (3)
- PTFS-Europe (10)
- Rijksmuseum (5)
- Solutions inLibro inc (3)
- Theke Solutions (9)
- ub.lu.se (1)

We also especially thank the following individuals who tested patches
for Koha

- Aleisha Amohia (1)
- Pedro Amorim (6)
- Anke (1)
- Tomás Cohen Arazi (196)
- Andrew Auld (17)
- Matt Blenkinsop (128)
- Christopher Brannon (1)
- Kevin Carnes (1)
- Nick Clemens (45)
- Paul Derscheid (2)
- Jonathan Druart (24)
- Magnus Enger (6)
- Laura Escamilla (4)
- Katrin Fischer (61)
- Andrew Fuerste-Henry (5)
- Brendan Gallagher (1)
- Lucas Gass (11)
- Amaury Gau (1)
- Victor Grousset (3)
- Kyle M Hall (4)
- Frank Hansen (3)
- Sally Healey (7)
- Heather Hernandez (1)
- Mason James (1)
- Janusz Kaczmarek (1)
- Jan Kissig (1)
- Owen Leonard (6)
- Julian Maurice (2)
- David Nind (54)
- Jacob O'Mara (88)
- Philip Orr (3)
- Séverine Queune (1)
- Martin Renvoize (15)
- Phil Ringnalda (7)
- Marcel de Rooy (23)
- Caroline Cyr La Rose (6)
- Lisette Scheer (1)
- Michaela Sieber (2)
- Fridolin Somers (1)
- Alexandra Speer (1)
- Clemens Tubach (1)



We regret any omissions.  If a contributor has been inadvertently missed,
please send a patch against these release notes to koha-devel@lists.koha-community.org.

## Revision control notes

The Koha project uses Git for version control.  The current development
version of Koha can be retrieved by checking out the master branch of:

- [Koha Git Repository](https://git.koha-community.org/koha-community/koha)

The branch for this version of Koha and future bugfixes in this release
line is 22.11.x.

## Bugs and feature requests

Bug reports and feature requests can be filed at the Koha bug
tracker at:

- [Koha Bugzilla](http://bugs.koha-community.org)

He rau ringa e oti ai.
(Many hands finish the work)

Autogenerated release notes updated last on 02 May 2023 14:53:58.
