package Koha::SIP2::Object;

# This file is part of Koha.
#
# Koha is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Koha is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Koha; if not, see <https://www.gnu.org/licenses>.

use Modern::Perl;

use base qw(Koha::Object);
use Koha::Caches;
use Koha::DateUtils qw( dt_from_string );

use DateTime;

=head1 NAME

Koha::SIP2::Object - Base class for SIP2 objects

=head1 SYNOPSIS

This is the base class for SIP2 objects in the Koha library system.

=head1 API

=head2 Class Methods

=cut

=head3 store

    store wrapper

=cut

sub store {
    my ($self) = @_;

    _update_config_timestamp();
    return $self->SUPER::store;
}

=head3 delete

    delete wrapper

=cut

sub delete {
    my ($self) = @_;

    _update_config_timestamp();
    return $self->SUPER::delete;
}

=head3 _update_config_timestamp

    Updates the sip2_resource_last_modified timestamp in cache

=cut

sub _update_config_timestamp {
    my $cache = Koha::Caches->get_instance();
    $cache->set_in_cache( 'sip2_resource_last_modified', dt_from_string()->epoch );
}

1;

