package Koha::Plugins::Tab;

# This file is part of Koha.
#
# Koha is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Koha is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Koha; if not, see <https://www.gnu.org/licenses>.

use Modern::Perl;

use Koha::Exceptions;

use base qw(Class::Accessor);

__PACKAGE__->mk_accessors(qw( title content id ));

=head1 NAME

Koha::Plugins::Tab - Simple base to abstract tabs to be generated by plugins

=head1 DESCRIPTION

Object-oriented class that represents tabs generated by plugins. Error handling on
mandatory fields is handled here.

=head1 API

=head2 Class methods

=head3 new

    my $tab = Koha::Plugins::Tab->new(
        {
            title   => 'A title',
            content => 'Some content'
        }
    );

Returns a Koha::Plugins::Tab object representing a plugin-generated tab.

=cut

sub new {

    my ( $class, $params ) = @_;

    Koha::Exceptions::MissingParameter->throw("Mandatory parameter 'title' missing")
        unless defined $params->{title};

    Koha::Exceptions::MissingParameter->throw("Mandatory parameter 'content' missing")
        unless defined $params->{content};

    my $self = {
        title   => $params->{title},
        content => $params->{content}
    };

    bless $self, $class;
    return $self;
}

1;
