[%- USE raw -%]
[%- USE Koha -%]
[%- USE Branches -%]
[%- SET data = {} -%]
[%- IF patron -%]
    [%- SET data.category_type  = patron.category.category_type -%]
    [%- SET data.surname        = patron.surname -%]
    [%- SET data.othernames     = patron.othernames -%]
    [%- SET data.firstname      = patron.firstname -%]
    [%- SET data.preferred_name = patron.preferred_name -%]
    [%- SET data.middle_name    = patron.middle_name -%]
    [%- SET data.cardnumber     = patron.cardnumber -%]
    [%- SET data.borrowernumber = patron.borrowernumber -%]
    [%- SET data.title          = patron.title -%]
[%- ELSIF ( borrower.borrowernumber ) -%]
    [%- SET data.category_type  = borrower.category_type -%]
    [%- SET data.surname        = borrower.surname -%]
    [%- SET data.othernames     = borrower.othernames -%]
    [%- SET data.firstname      = borrower.firstname -%]
    [%- SET data.preferred_name = borrower.preferred_name -%]
    [%- SET data.middle_name    = borrower.middle_name -%]
    [%- SET data.cardnumber     = borrower.cardnumber -%]
    [%- SET data.borrowernumber = borrower.borrowernumber -%]
    [%- SET data.title          = borrower.title -%]
[%- ELSIF ( borrowernumber ) -%]
    [%- SET data.category_type  = category_type -%]
    [%- SET data.surname        = surname -%]
    [%- SET data.othernames     = othernames -%]
    [%- SET data.firstname      = firstname -%]
    [%- SET data.preferred_name = preferred_name -%]
    [%- SET data.middle_name    = middle_name -%]
    [%- SET data.cardnumber     = cardnumber -%]
    [%- SET data.borrowernumber = borrowernumber -%]
    [%- SET data.title          = title -%]
[%- END -%]
[%# Parameter no_html - if 1, the html tags are NOT generated -%]
[%- SET display_patron_name = 1 -%]
[%- SET display_cardnumber = 1 -%]
[%- IF no_cardnumber -%][%- SET display_cardnumber = 0 -%][%- END -%]
[%- IF hide_patron_infos_if_needed -%]
    [%# Should only be set if patron is set -%]
    [%- SET can_see_patron_infos = logged_in_user.can_see_patron_infos( patron ) -%]
    [%- UNLESS can_see_patron_infos -%]
        [%- SET display_patron_name = 0 -%]
        [%- SET display_cardnumber  = 0 -%]
    [%- ELSIF Koha.Preference('HidePatronName') -%]
        [%- SET display_patron_name = 0 -%]
    [%- END -%]
[%- END -%]
[%- IF hide_patron_infos_if_needed AND ( display_patron_name OR display_cardnumber ) -%]
    [%- IF link_to == 'circulation_reserves' -%]
        <a href="/cgi-bin/koha/circ/circulation.pl?borrowernumber=[%- data.borrowernumber | uri -%]#reserves">[%- PROCESS display_patron_name -%]</a>
    [%- ELSIF link_to == 'circulation_recalls' -%]
        <a href="/cgi-bin/koha/circ/circulation.pl?borrowernumber=[%- data.borrowernumber | uri -%]#recalls">[%- PROCESS display_patron_name -%]</a>
    [%- ELSIF link_to == 'members_pay' -%]
        <a href="/cgi-bin/koha/members/pay.pl?borrowernumber=[%- patron.borrowernumber | uri -%]">[%- PROCESS display_patron_name -%]</a>
    [%- ELSE -%]
        <a href="/cgi-bin/koha/members/moremember.pl?borrowernumber=[%- data.borrowernumber | uri -%]">[%- PROCESS display_patron_name -%]</a>
    [%- END -%]
[%- ELSE -%]
    [%- PROCESS display_patron_name -%]
[%- END -%]
[%- BLOCK display_patron_name -%]
    [%- IF display_patron_name -%]
        [%- IF data.category_type == 'I' -%]
            [%- WRAPPER maybe_span field_name = 'surname' -%][%- data.surname | html -%][%- END -%]
            [%- IF data.othernames -%]([%- WRAPPER maybe_span field_name='othernames' -%][%- data.othernames | html -%][%- END -%])[%- END -%]
        [%- ELSIF invert_name -%]
            [%- UNLESS no_title %][%- WRAPPER maybe_span field_name='patron_title' -%][%- data.title _ ' ' | html -%][%- END -%][%- END -%]
            [%- WRAPPER maybe_span field_name='surname' -%][%- data.surname | html -%][%- END -%]
            [%- IF ( data.preferred_name ) -%], [%- WRAPPER maybe_span field_name='preferred_name' -%][% data.preferred_name | html -%][%- END -%][%- END -%]
            [%- IF data.middle_name -%][%- WRAPPER maybe_span field_name='middle_name' -%][% ' ' _ data.middle_name | html -%][%- END -%][%- END -%]
            [%- IF data.othernames -%]([%- WRAPPER maybe_span field_name='othernames' -%][%- data.othernames | html -%][%- END -%])[%- END -%]
        [%- ELSE -%]
            [%- UNLESS no_title %][%- WRAPPER maybe_span field_name='patron_title' -%][%- data.title _ ' ' | html -%][%- END -%][%- END -%]
            [%- WRAPPER maybe_span field_name='preferred_name' -%][%- data.preferred_name | html %][% END -%]
            [%- IF data.middle_name -%][%- WRAPPER maybe_span field_name='middle_name' -%][% ' ' _ data.middle_name | html -%][%- END -%][%- END -%]
            [%- IF data.othernames -%][%- WRAPPER maybe_span field_name='othernames' -%][%- ' (' _ data.othernames _ ')' | html -%][%- END -%][%- END -%]
            [%- WRAPPER maybe_span field_name='surname' -%][% ' ' _ data.surname | html -%][%- END -%]
        [%- END -%]
        [%- IF display_cardnumber AND data.cardnumber -%][%- WRAPPER maybe_span field_name='cardnumber' -%][%- ' (' _ data.cardnumber _ ')' | html -%][%- END -%][%- END -%]
    [%- ELSIF display_cardnumber -%]
        [%- IF data.cardnumber -%]
            [%# FIXME Cardnumber should always be defined, right? -%]
            [%- WRAPPER maybe_span field_name='cardnumber' -%][%- data.cardnumber | html -%][%- END -%]
        [%- END -%]
    [%- ELSE -%]
        <span>A patron from library [%- Branches.GetName( patron.branchcode ) | html -%]</span>
    [%- END -%]
[% END %]
[%- BLOCK maybe_span -%]
    [%- IF no_html -%]
        [%- content | $raw #filtered before passed in -%]
    [%- ELSE -%]
        <span class="[% field_name | html %]">[%- content | $raw #filtered before passed in -%]</span>
    [%- END -%]
[%- END -%]
