# RELEASE NOTES FOR KOHA 24.11.12
20 Jan 2026

Koha is the first free and open source software library automation
package (ILS). Development is sponsored by libraries of varying types
and sizes, volunteers, and support companies from around the world. The
website for the Koha project is:

- [Koha Community](https://koha-community.org)

Koha 24.11.12 can be downloaded from:

- [Download](https://download.koha-community.org/koha-24.11.12.tar.gz)

Installation instructions can be found at:

- [Koha Wiki](https://wiki.koha-community.org/wiki/Installation_Documentation)
- OR in the INSTALL files that come in the tarball

Koha 24.11.12 is a bugfix/maintenance release with 1 security patch.

It includes 3 enhancements, 10 bugfixes (2 security).

**System requirements**

You can learn about the system components (like OS and database) needed for running Koha on the [community wiki](https://wiki.koha-community.org/wiki/System_requirements_and_recommendations).


#### Security bugs

- [41593](https://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=41593) Authenticated SQL Injection in staff side suggestions
- [41662](https://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=41662) CSRF-vulnerability in opac-patron-consent.pl.

## Bugfixes

### Accessibility

#### Other bugs fixed

- [39502](https://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=39502) Web Usability Accessibility Audit - Decorative Images Don't Need alt Text

### Acquisitions

#### Other bugs fixed

- [39468](https://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=39468) EDI message status should be case insensitive
  >Fix EDI message status display in acquisitions so matching is case-insensitive by converting edi_order.status to lowercase before comparison.

### Architecture, internals, and plumbing

#### Other bugs fixed

- [38770](https://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=38770) Remove @vue/cli-service and babel
  >This removes unused dependencies following the move from webpack to Rspack (Bug 37824 - added to Koha 24.11). They were blocking upgrading ESLint and Node.js

### Command-line Utilities

#### Other bugs fixed

- [41490](https://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=41490) Duplicate variable definition warnings in `compare_es_to_db.pl`

### OPAC

#### Other bugs fixed

- [40803](https://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=40803) Users cannot renew overdue items from 'Overdue' tab in account

### Plugin architecture

#### Other bugs fixed

- [25952](https://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=25952) Github search errors make it impossible to install plugins from other repos
  >This fixes the error 500 "malformed JSON string" message when something goes wrong searching for plugins using the plugin search in the staff interface (for example, when there is an invalid repository in the Koha configuration).

### Preservation

#### Critical bugs fixed

- [41364](https://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=41364) Error in preservation module breadcrumb

### Staff interface

#### Other bugs fixed

- [40645](https://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=40645) When adding to a list the 'list name' field is cut off

## Enhancements 

### Architecture, internals, and plumbing

#### Enhancements

- [40527](https://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=40527) Add SECURITY.md to Koha
  >This enhancement adds a markdown file to the Koha project repository to make it clear how to report security issues.

### Authentication

#### Enhancements

- [34164](https://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=34164) OAuth2/OIDC should redirect to page that initiated login

### Staff interface

#### Enhancements

- [36518](https://bugs.koha-community.org/bugzilla3/show_bug.cgi?id=36518) Add unique IDs to the fieldsets of the item search form to enable customization
  >This enhancement adds IDs to the fieldsets on the staff interface search form (Search > Item search), to make CSS customization easier. The fieldset IDs are:
  >- Library and location section: librarylocation
  >- Item information section: access_and_condition
  >- Barcode search section: barcodesearch
  >- Call number section: callnumber_checkouts

## Documentation

The Koha manual is maintained in Sphinx. The home page for Koha
documentation is

- [Koha Documentation](https://koha-community.org/documentation/)
As of the date of these release notes, the Koha manual is available in the following languages:

- [English (USA)](https://koha-community.org/manual/24.11/en/html/)
- [French](https://koha-community.org/manual/24.11/fr/html/) (74%)
- [German](https://koha-community.org/manual/24.11/de/html/) (90%)
- [Greek](https://koha-community.org/manual/24.11/el/html/) (94%)
- [Hindi](https://koha-community.org/manual/24.11/hi/html/) (64%)

The Git repository for the Koha manual can be found at

- [Koha Git Repository](https://gitlab.com/koha-community/koha-manual)

## Translations

Complete or near-complete translations of the OPAC and staff
interface are available in this release for the following languages:
<div style="column-count: 2;">

- Arabic (ar_ARAB) (95%)
- Armenian (hy_ARMN) (100%)
- Bulgarian (bg_CYRL) (100%)
- Chinese (Simplified Han script) (86%)
- Chinese (Traditional Han script) (99%)
- Czech (68%)
- Dutch (88%)
- English (100%)
- English (New Zealand) (63%)
- English (USA)
- Finnish (99%)
- French (100%)
- French (Canada) (99%)
- German (100%)
- Greek (68%)
- Hindi (97%)
- Italian (82%)
- Norwegian Bokmål (73%)
- Persian (fa_ARAB) (96%)
- Polish (100%)
- Portuguese (Brazil) (99%)
- Portuguese (Portugal) (88%)
- Russian (94%)
- Slovak (60%)
- Spanish (99%)
- Swedish (88%)
- Telugu (67%)
- Tetum (52%)
- Turkish (83%)
- Ukrainian (76%)
- Western Armenian (hyw_ARMN) (62%)
</div>

Partial translations are available for various other languages.

The Koha team welcomes additional translations; please see

- [Koha Translation Info](https://wiki.koha-community.org/wiki/Translating_Koha)

For information about translating Koha, and join the koha-translate 
list to volunteer:

- [Koha Translate List](https://lists.koha-community.org/cgi-bin/mailman/listinfo/koha-translate)

The most up-to-date translations can be found at:

- [Koha Translation](https://translate.koha-community.org/)

## Release Team

The release team for Koha 24.11.12 is


- Release Manager: Lucas Gass

- QA Manager: Martin Renvoize

- QA Team:
  - Andrew Fuerste-Henry
  - Andrii Nugged
  - Baptiste Wojtkowski
  - Brendan Lawlor
  - David Cook
  - Emily Lamancusa
  - Jonathan Druart
  - Julian Maurice
  - Kyle Hall
  - Laura Escamilla
  - Lisette Scheer
  - Marcel de Rooy
  - Nick Clemens
  - Paul Derscheid
  - Petro V
  - Tomás Cohen Arazi
  - Victor Grousset

- Documentation Manager: David Nind

- Documentation Team:
  - Aude Charillon
  - Caroline Cyr La Rose
  - Donna Bachowski
  - Heather Hernandez
  - Kristi Krueger
  - Philip Orr

- Translation Manager: Jonathan Druart


- Wiki curators: 
  - George Williams
  - Thomas Dukleth

- Release Maintainers:
  - 25.05 -- Paul Derscheid
  - 24.11 -- Fridolin Somers
  - 24.05 -- Jesse Maseto
  - 22.11 -- Catalyst IT (Wainui, Alex, Aleisha)

- Release Maintainer assistants:
  - 25.05 -- Martin Renvoize
  - 24.11 -- Baptiste Wojtkowski
  - 24.05 -- Laura Escamilla

## Credits



We thank the following individuals who contributed patches to Koha 24.11.12
<div style="column-count: 2;">

- Rachel A-M (1)
- Tomás Cohen Arazi (2)
- Alexander Blanchard (1)
- Nick Clemens (2)
- David Cook (3)
- Jonathan Druart (2)
- Lucas Gass (1)
- Victor Grousset (1)
- David Gustafsson (1)
- Emily Lamancusa (1)
- Fridolin Somers (3)
- Baptiste Wojtkowski (3)
</div>

We thank the following libraries, companies, and other institutions who contributed
patches to Koha 24.11.12
<div style="column-count: 2;">

- [BibLibre](https://www.biblibre.com) (6)
- [ByWater Solutions](https://bywatersolutions.com) (3)
- Gothenburg University Library (1)
- Independant Individuals (1)
- Koha Community Developers (3)
- [Montgomery County Public Libraries](https://montgomerycountymd.gov) (1)
- [Open Fifth](https://openfifth.co.uk/) (1)
- [Prosentient Systems](https://www.prosentient.com.au) (3)
- [Theke Solutions](https://theke.io) (2)
</div>

We also especially thank the following individuals who tested patches
for Koha
<div style="column-count: 2;">

- Tomás Cohen Arazi (2)
- Paul Derscheid (6)
- Jonathan Druart (3)
- Laura Escamilla (7)
- Lucas Gass (8)
- Ludovic Julien (1)
- Lukas Koszyk (1)
- Emily Lamancusa (1)
- Owen Leonard (2)
- David Nind (3)
- Martin Renvoize (1)
- Marcel de Rooy (1)
- Lisette Scheer (2)
- Fridolin Somers (7)
- Baptiste Wojtkowski (5)
</div>





We regret any omissions.  If a contributor has been inadvertently missed,
please send a patch against these release notes to koha-devel@lists.koha-community.org.

## Revision control notes

The Koha project uses Git for version control.  The current development
version of Koha can be retrieved by checking out the main branch of:

- [Koha Git Repository](https://git.koha-community.org/koha-community/koha)

The branch for this version of Koha and future bugfixes in this release
line is 24.11.x.

## Bugs and feature requests

Bug reports and feature requests can be filed at the Koha bug
tracker at:

- [Koha Bugzilla](https://bugs.koha-community.org)

He rau ringa e oti ai.
(Many hands finish the work)

Autogenerated release notes updated last on 20 Jan 2026 15:47:29.
