use utf8;
package Koha::Schema::Result::Linktracker;

# Created by DBIx::Class::Schema::Loader
# DO NOT MODIFY THE FIRST PART OF THIS FILE

=head1 NAME

Koha::Schema::Result::Linktracker

=cut

use strict;
use warnings;

use base 'DBIx::Class::Core';

=head1 TABLE: C<linktracker>

=cut

__PACKAGE__->table("linktracker");

=head1 ACCESSORS

=head2 id

  data_type: 'integer'
  is_auto_increment: 1
  is_nullable: 0

primary key identifier

=head2 biblionumber

  data_type: 'integer'
  is_foreign_key: 1
  is_nullable: 1

biblionumber of the record the link is from

=head2 itemnumber

  data_type: 'integer'
  is_foreign_key: 1
  is_nullable: 1

itemnumber if applicable that the link was from

=head2 borrowernumber

  data_type: 'integer'
  is_foreign_key: 1
  is_nullable: 1

borrowernumber who clicked the link

=head2 url

  data_type: 'mediumtext'
  is_nullable: 1

the link itself

=head2 timeclicked

  data_type: 'datetime'
  datetime_undef_if_invalid: 1
  is_nullable: 1

the date and time the link was clicked

=cut

__PACKAGE__->add_columns(
  "id",
  { data_type => "integer", is_auto_increment => 1, is_nullable => 0 },
  "biblionumber",
  { data_type => "integer", is_foreign_key => 1, is_nullable => 1 },
  "itemnumber",
  { data_type => "integer", is_foreign_key => 1, is_nullable => 1 },
  "borrowernumber",
  { data_type => "integer", is_foreign_key => 1, is_nullable => 1 },
  "url",
  { data_type => "mediumtext", is_nullable => 1 },
  "timeclicked",
  {
    data_type => "datetime",
    datetime_undef_if_invalid => 1,
    is_nullable => 1,
  },
);

=head1 PRIMARY KEY

=over 4

=item * L</id>

=back

=cut

__PACKAGE__->set_primary_key("id");

=head1 RELATIONS

=head2 biblionumber

Type: belongs_to

Related object: L<Koha::Schema::Result::Biblio>

=cut

__PACKAGE__->belongs_to(
  "biblionumber",
  "Koha::Schema::Result::Biblio",
  { biblionumber => "biblionumber" },
  {
    is_deferrable => 1,
    join_type     => "LEFT",
    on_delete     => "SET NULL",
    on_update     => "SET NULL",
  },
);

=head2 borrowernumber

Type: belongs_to

Related object: L<Koha::Schema::Result::Borrower>

=cut

__PACKAGE__->belongs_to(
  "borrowernumber",
  "Koha::Schema::Result::Borrower",
  { borrowernumber => "borrowernumber" },
  {
    is_deferrable => 1,
    join_type     => "LEFT",
    on_delete     => "SET NULL",
    on_update     => "SET NULL",
  },
);

=head2 itemnumber

Type: belongs_to

Related object: L<Koha::Schema::Result::Item>

=cut

__PACKAGE__->belongs_to(
  "itemnumber",
  "Koha::Schema::Result::Item",
  { itemnumber => "itemnumber" },
  {
    is_deferrable => 1,
    join_type     => "LEFT",
    on_delete     => "SET NULL",
    on_update     => "SET NULL",
  },
);


# Created by DBIx::Class::Schema::Loader v0.07049 @ 2021-08-27 08:42:21
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:ksT3i//fQn+HnBKt4YZlhg

sub koha_object_class {
    'Koha::TrackedLink';
}
sub koha_objects_class {
    'Koha::TrackedLinks';
}

1;
