use utf8;
package Koha::Schema::Result::Accountline;

# Created by DBIx::Class::Schema::Loader
# DO NOT MODIFY THE FIRST PART OF THIS FILE

=head1 NAME

Koha::Schema::Result::Accountline

=cut

use strict;
use warnings;

use base 'DBIx::Class::Core';

=head1 TABLE: C<accountlines>

=cut

__PACKAGE__->table("accountlines");

=head1 ACCESSORS

=head2 accountlines_id

  data_type: 'integer'
  is_auto_increment: 1
  is_nullable: 0

=head2 issue_id

  data_type: 'integer'
  is_nullable: 1

=head2 borrowernumber

  data_type: 'integer'
  is_foreign_key: 1
  is_nullable: 1

=head2 itemnumber

  data_type: 'integer'
  is_foreign_key: 1
  is_nullable: 1

=head2 date

  data_type: 'timestamp'
  datetime_undef_if_invalid: 1
  is_nullable: 1

=head2 amount

  data_type: 'decimal'
  is_nullable: 1
  size: [28,6]

=head2 description

  data_type: 'longtext'
  is_nullable: 1

=head2 credit_type_code

  data_type: 'varchar'
  is_foreign_key: 1
  is_nullable: 1
  size: 80

=head2 debit_type_code

  data_type: 'varchar'
  is_foreign_key: 1
  is_nullable: 1
  size: 80

=head2 credit_number

  data_type: 'varchar'
  is_nullable: 1
  size: 20

autogenerated number for credits

=head2 status

  data_type: 'varchar'
  is_nullable: 1
  size: 16

=head2 payment_type

  data_type: 'varchar'
  is_nullable: 1
  size: 80

optional authorised value PAYMENT_TYPE

=head2 amountoutstanding

  data_type: 'decimal'
  is_nullable: 1
  size: [28,6]

=head2 timestamp

  data_type: 'timestamp'
  datetime_undef_if_invalid: 1
  default_value: current_timestamp
  is_nullable: 0

=head2 note

  data_type: 'mediumtext'
  is_nullable: 1

=head2 manager_id

  data_type: 'integer'
  is_foreign_key: 1
  is_nullable: 1

=head2 register_id

  data_type: 'integer'
  is_foreign_key: 1
  is_nullable: 1

=head2 interface

  data_type: 'varchar'
  is_nullable: 0
  size: 16

=head2 branchcode

  data_type: 'varchar'
  is_foreign_key: 1
  is_nullable: 1
  size: 10

the branchcode of the library where a payment was made, a manual invoice created, etc.

=cut

__PACKAGE__->add_columns(
  "accountlines_id",
  { data_type => "integer", is_auto_increment => 1, is_nullable => 0 },
  "issue_id",
  { data_type => "integer", is_nullable => 1 },
  "borrowernumber",
  { data_type => "integer", is_foreign_key => 1, is_nullable => 1 },
  "itemnumber",
  { data_type => "integer", is_foreign_key => 1, is_nullable => 1 },
  "date",
  {
    data_type => "timestamp",
    datetime_undef_if_invalid => 1,
    is_nullable => 1,
  },
  "amount",
  { data_type => "decimal", is_nullable => 1, size => [28, 6] },
  "description",
  { data_type => "longtext", is_nullable => 1 },
  "credit_type_code",
  { data_type => "varchar", is_foreign_key => 1, is_nullable => 1, size => 80 },
  "debit_type_code",
  { data_type => "varchar", is_foreign_key => 1, is_nullable => 1, size => 80 },
  "credit_number",
  { data_type => "varchar", is_nullable => 1, size => 20 },
  "status",
  { data_type => "varchar", is_nullable => 1, size => 16 },
  "payment_type",
  { data_type => "varchar", is_nullable => 1, size => 80 },
  "amountoutstanding",
  { data_type => "decimal", is_nullable => 1, size => [28, 6] },
  "timestamp",
  {
    data_type => "timestamp",
    datetime_undef_if_invalid => 1,
    default_value => \"current_timestamp",
    is_nullable => 0,
  },
  "note",
  { data_type => "mediumtext", is_nullable => 1 },
  "manager_id",
  { data_type => "integer", is_foreign_key => 1, is_nullable => 1 },
  "register_id",
  { data_type => "integer", is_foreign_key => 1, is_nullable => 1 },
  "interface",
  { data_type => "varchar", is_nullable => 0, size => 16 },
  "branchcode",
  { data_type => "varchar", is_foreign_key => 1, is_nullable => 1, size => 10 },
);

=head1 PRIMARY KEY

=over 4

=item * L</accountlines_id>

=back

=cut

__PACKAGE__->set_primary_key("accountlines_id");

=head1 RELATIONS

=head2 account_offsets_credits

Type: has_many

Related object: L<Koha::Schema::Result::AccountOffset>

=cut

__PACKAGE__->has_many(
  "account_offsets_credits",
  "Koha::Schema::Result::AccountOffset",
  { "foreign.credit_id" => "self.accountlines_id" },
  { cascade_copy => 0, cascade_delete => 0 },
);

=head2 account_offsets_debits

Type: has_many

Related object: L<Koha::Schema::Result::AccountOffset>

=cut

__PACKAGE__->has_many(
  "account_offsets_debits",
  "Koha::Schema::Result::AccountOffset",
  { "foreign.debit_id" => "self.accountlines_id" },
  { cascade_copy => 0, cascade_delete => 0 },
);

=head2 article_requests

Type: has_many

Related object: L<Koha::Schema::Result::ArticleRequest>

=cut

__PACKAGE__->has_many(
  "article_requests",
  "Koha::Schema::Result::ArticleRequest",
  { "foreign.debit_id" => "self.accountlines_id" },
  { cascade_copy => 0, cascade_delete => 0 },
);

=head2 borrowernumber

Type: belongs_to

Related object: L<Koha::Schema::Result::Borrower>

=cut

__PACKAGE__->belongs_to(
  "borrowernumber",
  "Koha::Schema::Result::Borrower",
  { borrowernumber => "borrowernumber" },
  {
    is_deferrable => 1,
    join_type     => "LEFT",
    on_delete     => "SET NULL",
    on_update     => "CASCADE",
  },
);

=head2 branchcode

Type: belongs_to

Related object: L<Koha::Schema::Result::Branch>

=cut

__PACKAGE__->belongs_to(
  "branchcode",
  "Koha::Schema::Result::Branch",
  { branchcode => "branchcode" },
  {
    is_deferrable => 1,
    join_type     => "LEFT",
    on_delete     => "SET NULL",
    on_update     => "CASCADE",
  },
);

=head2 credit_type_code

Type: belongs_to

Related object: L<Koha::Schema::Result::AccountCreditType>

=cut

__PACKAGE__->belongs_to(
  "credit_type_code",
  "Koha::Schema::Result::AccountCreditType",
  { code => "credit_type_code" },
  {
    is_deferrable => 1,
    join_type     => "LEFT",
    on_delete     => "RESTRICT",
    on_update     => "CASCADE",
  },
);

=head2 debit_type_code

Type: belongs_to

Related object: L<Koha::Schema::Result::AccountDebitType>

=cut

__PACKAGE__->belongs_to(
  "debit_type_code",
  "Koha::Schema::Result::AccountDebitType",
  { code => "debit_type_code" },
  {
    is_deferrable => 1,
    join_type     => "LEFT",
    on_delete     => "RESTRICT",
    on_update     => "CASCADE",
  },
);

=head2 itemnumber

Type: belongs_to

Related object: L<Koha::Schema::Result::Item>

=cut

__PACKAGE__->belongs_to(
  "itemnumber",
  "Koha::Schema::Result::Item",
  { itemnumber => "itemnumber" },
  {
    is_deferrable => 1,
    join_type     => "LEFT",
    on_delete     => "SET NULL",
    on_update     => "CASCADE",
  },
);

=head2 manager

Type: belongs_to

Related object: L<Koha::Schema::Result::Borrower>

=cut

__PACKAGE__->belongs_to(
  "manager",
  "Koha::Schema::Result::Borrower",
  { borrowernumber => "manager_id" },
  {
    is_deferrable => 1,
    join_type     => "LEFT",
    on_delete     => "SET NULL",
    on_update     => "CASCADE",
  },
);

=head2 register

Type: belongs_to

Related object: L<Koha::Schema::Result::CashRegister>

=cut

__PACKAGE__->belongs_to(
  "register",
  "Koha::Schema::Result::CashRegister",
  { id => "register_id" },
  {
    is_deferrable => 1,
    join_type     => "LEFT",
    on_delete     => "SET NULL",
    on_update     => "CASCADE",
  },
);


# Created by DBIx::Class::Schema::Loader v0.07049 @ 2022-01-28 20:21:02
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:PjQR7oUkefiDt+eV69jZ3A

=head2 library

Type: belongs_to

Related object: L<Koha::Schema::Result::Branch>

=cut

__PACKAGE__->belongs_to(
  "library",
  "Koha::Schema::Result::Branch",
  { branchcode => "branchcode" },
  {
    is_deferrable => 1,
    join_type     => "LEFT",
    on_delete     => "SET NULL",
    on_update     => "CASCADE",
  },
);

__PACKAGE__->has_many(
  "additional_field_values",
  "Koha::Schema::Result::AdditionalFieldValue",
  sub {
    my ($args) = @_;

    return {
        "$args->{foreign_alias}.record_id" => { -ident => "$args->{self_alias}.accountlines_id" },

        "$args->{foreign_alias}.field_id" =>
            { -in => \'(SELECT id FROM additional_fields WHERE tablename LIKE "accountlines:%")' },
    };
  },
  { cascade_copy => 0, cascade_delete => 0 },
);

sub koha_objects_class {
    'Koha::Account::Lines';
}
sub koha_object_class {
    'Koha::Account::Line';
}

1;
